/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-12-07
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>

#include "AverageAngle.h"

namespace QGpCoreMath {

  /*!
    \class AverageAngle AverageAngle.h
    \brief Brief description of class still missing

    Tools for computing average angle taking periodicity into account.
  */

  /*!
    Description of constructor still missing
  */
  AverageAngle::AverageAngle()
  {
    TRACE;
    clear();
  }

  void AverageAngle::clear()
  {
    TRACE;
    _count=0;
    _sum=0.0;
  }

  double AverageAngle::averageRadians() const
  {
    TRACE;
    return Angle::canonicalRadians(_sum/(double)_count);
  }

  double AverageAngle::averageDegrees() const
  {
    TRACE;
    return Angle::canonicalDegrees(_sum/(double)_count);
  }

  void AverageAngle::addRadians(double angle)
  {
    TRACE;
    angle=Angle::canonicalRadians(angle);
    if(_count==0) {
      _sum=angle;
    } else {
      double aver=averageRadians();
      _sum+=aver+Angle::differenceRadians(angle, aver);
    }
    _count++;
  }

  void AverageAngle::addDegrees(double angle)
  {
    TRACE;
    angle=Angle::canonicalDegrees(angle);
    if(_count==0) {
      _sum=angle;
    } else {
      double aver=averageDegrees();
      _sum+=aver+Angle::differenceDegrees(angle, aver);
    }
    _count++;
  }

} // namespace QGpCoreMath
