/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-04-28
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "CompatDispersion.h"

namespace QGpCompatibility {

int CompatDispersion::omegasCount (int m) const
{
  TRACE;
  int n=0;
  double * values=_values[m];
  for(int i=0;i<_omegasCount;i++) {
    if(values[i]!=0) n++;
  }
  return n;
}

void CompatDispersion::resetValues()
{
  TRACE;
  for(int mode=0; mode<_modesCount;mode++) {
    double * values=_values[mode];
    for(int i=0;i<_omegasCount;i++) values[i]=0;
  }
}

bool CompatDispersion::checkSlopes(double)
{
  TRACE;
  bool ret=true;
  double smin=std::numeric_limits<double>::infinity();
  for(int mode=0; mode<_modesCount;mode++) {
    double * values=_values[mode];
    int i=0;
    for(; values[i]==0 && i<_omegasCount; i++) {}
    for(i++; i<_omegasCount; i++) {
      // Normally slowness curve is increasing with frequency
      // But some Rayleigh curve can decrease on some small portion
      // with very gentle slopes.
      // It's not easy to define a threshold but we are going to aquire some
      // experience
      if(values[i]<=values[i-1])
      {
        double s=values[i-1]-values[i]/(_omegas[i-1]-_omegas[i]);
        if(s<smin) smin=s;
        ret=false;
      }
    }
  }
  if(!ret)
    printf("*** WARNING ***: slowness decreasing with frequency, max slope=%lg\n",smin);
  return ret;
}

} // namespace QGpCompatibility
