/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-30
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef STUDENTTESTCURVEMODEL_H
#define STUDENTTESTCURVEMODEL_H

#include <HVCore.h>

#include "StudentTest.h"
#include "HVGuiDLLExport.h"

namespace HVGui {

  class HVGUI_EXPORT StudentTestCurveModel : public QAbstractItemModel
  {
  public:
    StudentTestCurveModel(QObject * parent=nullptr);
    ~StudentTestCurveModel();

    void setList(const StudentTest::ResultLists& curves);

    virtual int rowCount(const QModelIndex& parent) const;
    virtual int columnCount(const QModelIndex&) const;
    virtual QVariant data(const QModelIndex& index, int role) const;
    virtual QModelIndex parent(const QModelIndex& index) const;
    virtual QModelIndex index (int row, int column, const QModelIndex& parent) const;
    virtual Qt::ItemFlags flags (const QModelIndex&) const;

    CurveResults * results(const QModelIndex& index) const;
  private:
    StudentTest::ResultLists _curves;
    QStringList _lists;
  };

} // namespace HVGui

#endif // STUDENTTESTCURVEMODEL_H
