/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-26
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SpectrumRotateStation.h"
#include "HVParameters.h"
#include "HVStationSignals.h"

namespace HVCore {

  /*!
    \class SpectrumRotateStation SpectrumRotateStation.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  SpectrumRotateStation::SpectrumRotateStation(StationSignals * sig)
    : SpectrumStation(sig)
  {
    TRACE;
  }

  StationProcessSignals * SpectrumRotateStation::createProcessSignals()
  {
    return new HVStationSignals;
  }

  AbstractResults * SpectrumRotateStation::createResults()
  {
    AbstractResults * r=new RotateResults(this);
    r->setName(originalSignals()->name());
    return r;
  }

  void SpectrumRotateStation::process(StationProcessSignals * proc, int windowIndex, const HVParameters * param) const
  {
    TRACE;
    HVStationSignals * spectrumProc=static_cast<HVStationSignals *>(proc);
    const TimeWindow& r=windowAt(windowIndex);
    spectrumProc->setProcessed(_signals, r, param);

    RotateResults& res=*static_cast<RotateResults *>(_results[0]);
    int n=res.azimuthCount();
    for(int i=0; i<n; i++) {
      Curve<Point2D> spec=spectrumProc->horizontal(res.azimuth(i), param);
      res.setWindow(i, r.lengthSeconds(), spec);
    }
  }

} // namespace HVCore

