/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-13
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TIMERANGEPARAMETERWIDGET_H
#define TIMERANGEPARAMETERWIDGET_H

#include <GeopsyCore.h>

#include "ui_TimeRangeParameterWidget.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

  class GEOPSYGUI_EXPORT TimeRangeParameterWidget : public QWidget, private Ui::TimeRangeParameterWidget
  {
    Q_OBJECT
  public:
    TimeRangeParameterWidget(QWidget *parent=nullptr, Qt::WindowFlags f=nullptr);

    void setSubPool(const SubSignalPool * subPool);

    void getParameters(TimeRangeParameters & param) const;
    void setParameters(const TimeRangeParameters & param);
  public slots:
    void updatePicks();
    void updateAllFields();
  private slots:
    void referenceEditChanged();
    void fromTypeChanged();
    void toTypeChanged();
  signals:
    void parametersChanged();
  private:
    QMap<QString,int> _signalNames;
    const SubSignalPool * _subPool;
    SubSignalPool _reference;
    QStringList _pickNames;
  };

} // namespace GeopsyGui

#endif // TIMERANGEPARAMETERWIDGET_H
