/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-09-23
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTGRAPHICWINDOW_H
#define ABSTRACTGRAPHICWINDOW_H

#include "SubPoolWindow.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

  class SignalLayer;
  class TimeWindowLayer;
  class PickLayer;

  class GEOPSYGUI_EXPORT AbstractGraphicWindow : public SubPoolWindow
  {
  public:
    AbstractGraphicWindow(QWidget* parent=nullptr) : SubPoolWindow(parent) {}
    virtual ~AbstractGraphicWindow() {}

    virtual SignalLayer * signalLayer() const=0;
    virtual TimeWindowLayer * timeWindowLayer() const=0;
    virtual PickLayer * pickLayer() const=0;

    void setLimits();
  };

} // namespace GeopsyGui

#endif // ABSTRACTGRAPHICWINDOW_H
