/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-07-28
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SORTKEY_H
#define SORTKEY_H

#include <QtCore>

#include "MetaDataIndex.h"
#include "GeoSignal.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT SortKey : public MetaDataIndex
  {
  public:
    SortKey(const MetaDataIndex& d, bool r=false) : MetaDataIndex(d) {_reversed=r;}
    SortKey(int id, bool r=false) : MetaDataIndex(id, 0, nullptr) {_reversed=r;}
    SortKey(const SortKey& o) : MetaDataIndex(o) {_reversed=o._reversed;}

    bool reversed() const {return _reversed;}

    static inline bool lessThan(const Signal * sig1, const Signal * sig2);
    static void clear() {_keys.clear();}
    static void add(const SortKey& k) {_keys.append(k);}
    static int count() {return _keys.count();}
    static const SortKey& at(int index) {return _keys.at(index);}
  private:
    bool _reversed;

    static QList<SortKey> _keys;
  };

  inline bool SortKey::lessThan(const Signal * sig1, const Signal * sig2)
  {
    return *sig1 < *sig2;
  }

} // namespace GeopsyCore

#endif // SORTKEY_H
