/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-12-12
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef KEEPSIGNAL_H
#define KEEPSIGNAL_H

#include "SignalTemplate.h"
#include "TimeRange.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class Signal;

  class GEOPSYCORE_EXPORT KeepSignal : public SignalTemplate<int>
  {
  public:
    KeepSignal();
    KeepSignal(int n);
    KeepSignal(const KeepSignal& o);

    // Properties
    double samplingPeriod() const {return _samplingPeriod;}
    void setSamplingPeriod(double newval) {_samplingPeriod=newval;}
    double samplingFrequency() const {return 1.0/_samplingPeriod;}
    double duration() const {return _samplingPeriod*_nSamples;}
    const DateTime& startTime() const {return _startTime;}
    void setStartTime(const DateTime& t) {_startTime=t;}
    DateTime endTime() const {return _startTime+duration();}
    TimeRange timeRange() const {return TimeRange(_startTime, duration());}

    void debugPrint() const;
  protected:
    virtual inline QString debugName() const;
  private:
    double _samplingPeriod;
    DateTime _startTime;
  };

  inline QString KeepSignal::debugName() const
  {
    return QString("keep_%1").arg(reinterpret_cast<qint64>(this), 0, 16);
  }

} // namespace GeopsyCore

#endif // KEEPSIGNAL_H
