/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-08-16
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GSE_H
#define GSE_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT Gse
{
  TRANSLATIONS("Gse")
public:
  static char * compress6(int nData, int * data, int& iComp);
  static bool decompress6(int nComp, const char * comp, int nData, int * data);
  static void diff(int * data, int nData);
  static void remdif(int * data, int nData);
  static int checksum(int * data, int nData);
private:
  inline static unsigned int ascii2gseChar(unsigned char c);
  inline static unsigned char gseChar2ascii(unsigned int c);
};

} // namespace GeopsyCore

#endif // GSE_H
