/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-02-14
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTTOOL_H
#define ABSTRACTTOOL_H

#include "SubSignalPool.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT AbstractTool : public QObject
  {
    Q_OBJECT
  public:
    AbstractTool(QObject * parent=nullptr);
    virtual ~AbstractTool();

    virtual bool setSubPool(SubSignalPool * subPool);
    SubSignalPool * subPool() const {return _subPool;}

    virtual bool setParameters(const AbstractParameters& param);
    const AbstractParameters * parameters() const {return _param;}
    AbstractParameters * parameters() {return _param;}

    bool setLoop();
    ParallelTaskManager * loop() const {return _loop;}

    SignalDatabase * database() const {return _subPool->database();}

    virtual void waitFinished();
    void showProgress();
    const QString& log() const {return _log;}
  public slots:
    virtual void start();
    void stop();
  protected slots:
    void finish();
  signals:
    void finished();
  protected:
    virtual ParallelTaskManager * createLoop() {return nullptr;}
  private:
    SubSignalPool * _subPool;
    AbstractParameters * _param;
    ParallelTaskManager * _loop;
    QElapsedTimer _chrono;
    QString _log;
  };

} // namespace GeopsyCore

#endif // ABSTRACTTOOL_H

