/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-02-14
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "AbstractTool.h"

namespace GeopsyCore {

  /*!
    \class AbstractTool AbstractTool.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  AbstractTool::AbstractTool(QObject * parent)
    : QObject(parent)
  {
    TRACE;
    _loop=nullptr;
    _subPool=nullptr;
    _param=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  AbstractTool::~AbstractTool()
  {
    TRACE;
    delete _loop;
    delete _param;
  }

  bool AbstractTool::setSubPool(SubSignalPool * subPool)
  {
    TRACE;
    _subPool=subPool;
    if(_subPool->isEmpty()) {
      App::log(tr("Empty list of signals\n") );
      return false;
    } else {
      return true;
    }
  }

  bool AbstractTool::setParameters(const AbstractParameters& param)
  {
    TRACE;
    delete _param;
    _param=param.clone();
    return true;
  }

  bool AbstractTool::setLoop()
  {
    delete _loop;
    _loop=createLoop();
    if(_loop) {
      connect(_loop, SIGNAL(finished()), this, SLOT(finish()));
      return true;
    } else {
      return false;
    }
  }

  void AbstractTool::start()
  {
    TRACE;
    _log.clear();
    QString oldPrefix=App::prefix();
    App::setPrefix(oldPrefix+" [PARAM] ");
    App::log(parameters()->AbstractParameters::toString()+parameters()->toString()+"\n");
    App::setPrefix(oldPrefix);

    if(App::verbosity()>=3) {
      App::log(tr("Preloading signals to remove loading time for the global timing report.\n"));
      for(int i=0; i<_subPool->count(); i++) {
        Signal * sig=_subPool->at(i);
        sig->lockSamples();
        sig->unlockSamples();
      }
    }

    QString log;
    log=tr("Process started at %1\n").arg(QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm:ss"));
     App::log(log);
     _log+=log;
    _chrono.start();
    _loop->start();
  }

  void AbstractTool::finish()
  {
    QTime timeElapsed(0,0);
    QString log;
    log=tr("\nProcess ended at %1\n").arg(QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm:ss"))
       +tr("Process run in %1\n").arg(timeElapsed.addMSecs(_chrono.elapsed()).toString("hh:mm:ss"));
    App::log(log);
    _log+=log;
    emit finished();
  }

  void AbstractTool::waitFinished()
  {
    TRACE;
    if(_loop) {
      _loop->waitFinished();
    }
  }

  void AbstractTool::stop()
  {
    TRACE;
    if(_loop) {
      _loop->terminate();
    }
  }

  void AbstractTool::showProgress()
  {
    TRACE;
    _loop->showProgress();
  }

} // namespace GeopsyCore

