/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-20
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MAGNETOTELLURICTARGET_H
#define MAGNETOTELLURICTARGET_H

#include <QGpCoreWave.h>

#include "Target.h"
#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

class DINVERDCCORE_EXPORT MagnetoTelluricTarget : public Target
{
public:
  MagnetoTelluricTarget();
  MagnetoTelluricTarget(const MagnetoTelluricTarget& o);

  virtual const QString& xml_tagName() const {return xmlMagnetoTelluricTargetTag;}
  static const QString xmlMagnetoTelluricTargetTag;

  const QList<MagnetoTelluricCurve>& curves() const {return _curves;}
  QList<MagnetoTelluricCurve>& curves() {return _curves;}
  void setCurves(const QList<MagnetoTelluricCurve>& c);
protected:
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
private:
  QList<MagnetoTelluricCurve> _curves;
};

} // namespace DinverDCCore

#endif // MAGNETOTELLURICTARGET_H
