/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-09
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "GroundParameter.h"
#include "ParamLayer.h"

namespace DinverDCCore {

  /*!
    \class GroundParameter GroundParameter.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  GroundParameter::GroundParameter(const ParamGroundModel * groundModel, const ParamLayer * layer,
                                   Type type, double min, double max)
      : Parameter()
  {
    TRACE;

    _groundModel=groundModel;
    _layers << layer;
    _type=type;
    switch(_type) {
    case ValueTop:
      setName("Top"+layer->name());
      setUnit(layer->unit());
      break;
    case ValueGradient:
      setName("Gradient"+layer->name());
      setUnit("");
      break;
    case ValueBottom:
      setName("Bottom"+layer->name());
      setUnit(layer->unit());
      break;
    case Depth:
      setName("D"+layer->name());
      setUnit("m");
      break;
    case Thickness:
      setName("H"+layer->name());
      setUnit("m");
      break;
    }
    setMinimum(min);
    setMaximum(max);
    // Default log scale with 1% error
    setScale(ParameterGrid::Log);
    setPrecision(0.01);
    // Mimic continuous parameters for testing only
    //setScale(ParameterGrid::Log);
    //setPrecision(0.000001);
    /*
    // Comparison of linear versus log scale
    setScale(ParameterGrid::Linear);
    setPrecision(0.0);
    */
  }

} // namespace DinverDCCore
