/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-04-21
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TEMPORARYDIRECTORY_H
#define TEMPORARYDIRECTORY_H

#include <QtCore>
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class DINVERCORE_EXPORT TemporaryDirectory : public QObject, private QDir
{
  Q_OBJECT
public:
  TemporaryDirectory(QObject * parent=nullptr);
  ~TemporaryDirectory();

  QString absolutePath() const {return QDir::absolutePath();}
private slots:
  void keepAlive();
private:
  void setPath(QString p);
  void clear();

  QTimer _keepAlive;
  static int _instanceCount;
};

} // namespace DinverCore

#endif // TEMPORARYDIRECTORY_H
