/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-06
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIMPLEX_H
#define SIMPLEX_H

#include "DinverCoreDLLExport.h"

namespace DinverCore {

class DINVERCORE_EXPORT Simplex
{
public:
  inline Simplex(int firstNode);
  inline Simplex(const Simplex& o);
private:
  int _firstNode;
};

inline Simplex::Simplex(int firstNode)
{
  _firstNode=firstNode;
}

inline Simplex::Simplex(const Simplex& o)
{
  _firstNode=o._firstNode;
}

} // namespace DinverCore

#endif // SIMPLEX_H
