/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-05-12
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "Model.h"
#include "ModelSet.h"

namespace DinverCore {

/*!
  \class Model Model.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

bool Model::operator==(const Model& o) const
{
  const int * p1=data();
  const int * p2=o.data();
  for(int ip=parameterCount()-1; ip>=0; ip-- ) {
    if(p1[ip]!=p2[ip]) return false;
  }
  return true;
}

void Model::print() const
{
  print(parameterCount(), data());
}

void Model::print(int parameterCount, const int * data)
{
  for(int i=0;i < parameterCount;i++ ) {
    printf("%i\t",data[ i ]);
  }
  printf("\n");
}

/*!
  Copied from hash(const uchar *p, int n) in qhash.cpp not accessible
  through Qt interface.
*/
uint qHash(const Model& m)
{
  uint h=0;
  uint g;
  int n=sizeof(int)*m.parameterCount();
  const uchar * p=reinterpret_cast<const uchar *>(m.data());
  while(n--) {
      h=(h << 4) + *p++;
      if((g=(h & 0xf0000000))!=0)
          h ^= g >> 23;
      h &= ~g;
  }
  return h;
}

} // namespace DinverCore
