/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-09-04
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef INDEX_H
#define INDEX_H

#include "DinverCoreDLLExport.h"

namespace DinverCore {

  class DINVERCORE_EXPORT Index
  {
  public:
    Index() {_value=0;}
    Index(const Index& o) {_value=o._value;}

    bool operator==(const Index& o) const {return _value==o._value;}
    bool operator<(const Index& o) const {return _value<o._value;}
    bool operator<=(const Index& o) const {return _value<=o._value;}
    bool operator>(const Index& o) const {return _value>o._value;}
    bool operator>=(const Index& o) const {return _value>=o._value;}
    bool isValid() const {return _value>=0;}

    void operator=(const Index& o) {_value=o._value;}
    void operator+=(const Index& o) {_value+=o._value;}
    void operator-=(const Index& o) {_value-=o._value;}
    void operator++(int) {_value++;}
    void operator--(int) {_value--;}
    void divideBy2() {_value=_value >> 1;}

    void setValue(int v) {_value=v;}
    int value() const {return _value;}
  private:
    int _value;
  };

  class DINVERCORE_EXPORT SetIndex : public Index
  {
  public:
    SetIndex() : Index() {}
    SetIndex(const SetIndex& o) : Index(o) {}

    static SetIndex null;
    static SetIndex first;
  private:
    SetIndex(int v) {setValue(v);}
  };

  class DINVERCORE_EXPORT ActiveIndex : public Index
  {
  public:
    ActiveIndex() : Index() {}
    ActiveIndex(const ActiveIndex& o) : Index(o) {}

    static ActiveIndex null;
    static ActiveIndex first;
  private:
    ActiveIndex(int v) {setValue(v);}
  };

  class DINVERCORE_EXPORT BestIndex : public Index
  {
  public:
    BestIndex() : Index() {}
    BestIndex(const BestIndex& o) : Index(o) {}

    static BestIndex null;
    static BestIndex first;
  private:
    BestIndex(int v) {setValue(v);}
  };

  class DINVERCORE_EXPORT TargetIndex : public Index
  {
  public:
    TargetIndex() : Index() {}
    TargetIndex(const TargetIndex& o) : Index(o) {}

    static TargetIndex null;
    static TargetIndex first;
  private:
    TargetIndex(int v) {setValue(v);}
  };

} // namespace DinverCore

#endif // INDEX_H

