/***************************************************************************
**
**  This file is part of ArrayGui.
**
**  ArrayGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-13
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef RINGEDITOR_H
#define RINGEDITOR_H

#include <ArrayCore.h>
#include <GeopsyGui.h>

#include "ui_RingEditor.h"
#include "ArrayGuiDLLExport.h"

namespace ArrayGui {

#define RingEditor_MinCol 0
#define RingEditor_MaxCol 1
#define RingEditor_PairsNumCol 2
#define RingEditor_AverageRadiusCol 3
#define RingEditor_ThicknessCol 4
#define RingEditor_AngleStepCol 5
#define RingEditor_ColorCol 6

class RingEditorDelegate : public QItemDelegate
{
  Q_OBJECT
public:
  RingEditorDelegate(QObject *parent=nullptr);

  QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,
                        const QModelIndex &index) const;
  void setEditorData(QWidget *editor, const QModelIndex &index) const;
  void setModelData(QWidget *editor, QAbstractItemModel *model,
                    const QModelIndex &index) const;
private slots:
  inline void commitSpin();
};

inline void RingEditorDelegate::commitSpin()
{
  TRACE;
  DoubleSpinBox * w=qobject_cast<DoubleSpinBox *>(sender());
  if(w) emit commitData (w);
}

class ARRAYGUI_EXPORT RingEditor : public QWidget, public Ui::RingEditor
{
  Q_OBJECT
public:
  RingEditor(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);
  ~RingEditor();

  int ringCount();

  void clear();
  void addRing(double minR, double maxR);
  void setArray(const ArraySelection& array);
  void setArray(const QList<NamedPoint>& array);
  void updateProperties();
  void autoRings() {on_autoBut_clicked();}
public slots:
  void setCoArrayGraph(ArrayMap * w);
private slots:
  void on_addBut_clicked();
  void on_removeBut_clicked();
  void on_rings_itemClicked(QTableWidgetItem * item);
  void on_rings_itemChanged(QTableWidgetItem * item);
  void updateGraph();
  void on_loadBut_clicked();
  void load(QString fileName);
  void on_saveBut_clicked();
  void on_optimizeBut_clicked();
  void on_autoBut_clicked();
private:
  void initRow(int row);
  QVector<int> selectedRows() const;

  QVector<StationPair> _pairs;
  QVector<SPACRing> * _rings;
  CircleViewer * _circleLayer;
};

} // namespace ArrayGui

#endif // RINGEDITOR_H
