/***************************************************************************
**
**  This file is part of ArrayGui.
**
**  ArrayGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-19
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef BLOCKAVERAGINGPARAMETERWIDGET_H
#define BLOCKAVERAGINGPARAMETERWIDGET_H

#include <ArrayCore.h>

#include "ui_BlockAveragingParameterWidget.h"
#include "ArrayGuiDLLExport.h"

namespace ArrayGui {

  class ARRAYGUI_EXPORT BlockAveragingParameterWidget : public QWidget, private Ui::BlockAveragingParameterWidget
  {
    Q_OBJECT
  public:
    BlockAveragingParameterWidget(QWidget * parent=nullptr);
    ~BlockAveragingParameterWidget();

    void getParameters(BlockAveragingParameters & param);
    void setParameters(const BlockAveragingParameters & param);

    void updateAllFields();
  signals:
    void parametersChanged();
  private slots:
    void on_countEdit_valueChanged(int value);
  };

} // namespace ArrayGui

#endif // BLOCKAVERAGINGPARAMETERWIDGET_H

