/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-03-07
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SPACRING_H
#define SPACRING_H

#include <QGpCoreWave.h>

#include "ArrayCoreDLLExport.h"
#include "StationPair.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT SPACRing : public AutocorrRing
  {
  public:
    SPACRing();
    SPACRing(double minR, double maxR);
    ~SPACRing();

    void add(const StationPair * p);
    void setPairs(const QVector<StationPair>& stationPairs);
    void removeFirst();

    double maximumAngleStep(int startIndex=0) const;
    double overlap(const SPACRing& o) const;

    double thickness() const {return maxRadius()-minRadius();}
    double averageRadius() const {return 0.5*(minRadius()+maxRadius());}

    int count() const {return _pairs.count();}

    static QVector<SPACRing> autoRings(const QVector<StationPair>& pairs,
                                       double maxAngleStep=40.0,
                                       double maxRelThickness=0.2,
                                       int minPairCount=6,
                                       double maxOverlap=0.5);
    static bool isLinear(const QVector<StationPair>& pairs);
  private:
    static bool lessThanDistance(const StationPair * p1,
                                 const StationPair * p2);
    static bool lessThanAzimuth(const StationPair * p1,
                                const StationPair * p2);

    QList<const StationPair *> _pairs;
  };

} // namespace ArrayCore

#endif // SPACRING_H

