/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-12
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef KMAXSOLVER_H
#define KMAXSOLVER_H

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class ARRAYCORE_EXPORT KmaxSolver: public Thread, public TheoreticalLinearFK, private ConcentricSearch
{
  Q_OBJECT
public:
  KmaxSolver(const QVector<Point2D>& stations, double kmin, double threshold);
  ~KmaxSolver();

  bool calculate();
  void terminate();

  double kmax(bool& ok) const;
private:
  virtual void run();

  QAtomicInt _terminated;
  mutable Mutex _kMutex;
  double _kminHalf;
  double _dk;
  double _kmax;
  bool _valid;
};

} // namespace ArrayCore

#endif // KMAXSOLVER_H
