/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-12
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "HRFKVertical.h"
#include "FKPower.h"
#include "FKSteeringOneComponent.h"

namespace ArrayCore {

  /*!
    \class HRFKVertical HRFKVertical.h
    \brief Vertical high resolution FK power

    Vertical high resolution FK power versus wavenumber (k) function.
  */

  HRFKVertical::HRFKVertical(FKCache * cache)
    : ConvFKVertical(cache)
  {
    _countGrid=0;
    _countFree=0;
  }

  HRFKVertical::~HRFKVertical()
  {
    App::log(tr("%1 grid values, %2 free values\n").arg(_countGrid).arg(_countFree));
  }

  bool HRFKVertical::invertCrossSpectrum()
  {
    return _crossSpectrum->invert();
  }

  double HRFKVertical::value(const Point& k, int index) const
  {
    if(isInsideLimits(k)) {
      _countGrid++;
      FKPower p(&FKSteeringOneComponent::cache(_gridCache, index));
      p.setCaponValue(_crossSpectrum->matrix());
      return p.value();
    } else {
      return -1.0;
    }
  }

#if 0
  void HRFKVertical::setGradient(FKPower& p) const
  {
    _countGrid++;
    p.setCaponValue(_crossSpectrum->matrix());
    p.setOneComponentGradient();
  }

  void HRFKVertical::setHessian(FKPower &p) const
  {
    _countGrid+=2;
    p.setOneComponentHessian(_crossSpectrum->matrix());
  }
#endif

  double HRFKVertical::value(const Point& k) const
  {
    if(isInsideLimits(k)) {
      _countFree++;
      FKSteeringOneComponent * s=static_cast<FKSteeringOneComponent *>(_steering);
      s->initValue(k);
      FKPower p(s);
      p.setCaponValue(_crossSpectrum->matrix());
      return p.value();
    } else {
      return -1;
    }
  }

#if 0
  void HRFKVertical::setGradient(const Point& k, FKPower& p) const
  {
    _countFree++;
    FKSteeringOneComponent * s=static_cast<FKSteeringOneComponent *>(_steering);
    s->initValue(k);
    s->initGradient();
    p.setCaponValue(_crossSpectrum->matrix());
    p.setOneComponentGradient();
  }

  void HRFKVertical::setHessian(const Point&, FKPower& p) const
  {
    FKSteeringOneComponent * s=static_cast<FKSteeringOneComponent *>(_steering);
    s->initHessian();
    p.setOneComponentHessian(_crossSpectrum->matrix());
  }
#endif

} // namespace ArrayCore
