/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-04-12
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "FKSteeringOneComponent.h"

namespace ArrayCore {

  const int FKSteeringOneComponent::sizeFactor=1;

  /*!
    \class FKSteeringOneComponent FKSteeringOneComponent.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  void FKSteeringOneComponent::init(FKCache * cache, int index, const Point2D& k)
  {
    FKSteeringOneComponent& s=FKSteeringOneComponent::cache(cache, index);
    s.resize();
    s.initValue(k);
    //s.initGradient();
    //s.initHessian();
  }

  void FKSteeringOneComponent::initValue(const Point2D& k)
  {
    int stationCount=_array->count();
    for(int i=stationCount-1; i>=0; i--) {
      const Point2D& r=_array->relativePos(i);
      Complex& eh=_eh.at(0, i);
      Complex& e=_e.at(i, 0);
      // Values required for power steering
      e.setUnitExp(-r.scalarProduct(k));
      eh=conjugate(e);
    }
  }

#if 0
  /*!
    initValue() must be executed first.
  */
  void FKSteeringOneComponent::initGradient()
  {
    int stationCount=_array->count();
    for(int i=stationCount-1; i>=0; i--) {
      const Point2D& r=_array->relativePos(i);
      const Complex& eh=_eh.at(0, i);
      _ehrx.at(0, i)=eh*r.x();
      _ehry.at(0, i)=eh*r.y();
    }
  }

  /*!
    initGadient() must be executed first.
  */
  void FKSteeringOneComponent::initHessian()
  {
    int stationCount=_array->count();
    for(int i=stationCount-1; i>=0; i--) {
      const Point2D& r=_array->relativePos(i);
      const Complex& e=_e.at(i, 0);
      Complex& ehrx=_ehrx.at(0, i);

      _ehrxrx.at(0, i)=ehrx*r.x();
      _ehrxry.at(0, i)=ehrx*r.y();
      _ehryry.at(0, i)=_ehry.at(0, i)*r.y();

      _rxe.at(i, 0)=e*r.x();
      _rye.at(i, 0)=e*r.y();
    }
  }
#endif

} // namespace ArrayCore

