/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-08-23
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <math.h>

#include "FKGridSearch.h"

namespace ArrayCore {

  FKGridSearch::FKGridSearch()
  {
    TRACE;
    setRelativePrecision(0, FunctionSearchMaximum::relativePrecision);
    setRelativePrecision(1, FunctionSearchMaximum::relativePrecision);
    setEllipticityPrecision(2);
  }

  void FKGridSearch::setEllipticityPrecision(int axis)
  {
    setAbsolutePrecision(axis, M_PI/1800); // 1/10 deg.
  }

} // namespace ArrayCore
