/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-04-10
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef BLOCKAVERAGINGPARAMETERS_H
#define BLOCKAVERAGINGPARAMETERS_H

#include <GeopsyCore.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT BlockAveragingParameters : public AbstractParameters
  {
  public:
    BlockAveragingParameters();
    BlockAveragingParameters(const BlockAveragingParameters& o);

    virtual AbstractParameters * clone() const {return new BlockAveragingParameters(*this);}

    bool blockOverlap() const {return _overlap;}
    void setBlockOverlap(bool o) {_overlap=o;}

    int count(int stationCount) const;
    int count() const {return _count;}
    void setCount(int n) {_count=n;}

    double countFactor() const {return _countFactor;}
    void setCountFactor(double f) {_countFactor=f;}

    int statisticCount() const {return _statisticCount;}
    void setStatisticCount(int n) {_statisticCount=n;}

    double statisticMaxOverlap() const {return _statisticMaxOverlap;}
    void setStatisticMaxOverlap(double n);

    int increment(const TimeRangeList& winList, const QVector<int>& blocks) const;
    QVector<int> list(int firstWindowIndex, int stationCount,
                      const TimeRangeList& winList) const;

    virtual QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
    virtual void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
  protected:
    virtual int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
    virtual bool setValue(PARAMETERS_SETVALUE_ARGS);
  private:
    int _count;
    int _statisticCount;
    bool _overlap;
    double _countFactor;
    double _statisticMaxOverlap;
  };

} // namespace ArrayCore

#endif // BLOCKAVERAGINGPARAMETERS_H
