/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-06-21
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ArrayStationSignals_H
#define ArrayStationSignals_H

#include <GeopsyCore.h>

#include "ArrayCoreDLLExport.h"
#include "FKParameters.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ArrayStationSignals : public StationProcessSignals
  {
  public:
    ArrayStationSignals(const StationSignals * originalSignals);
    ~ArrayStationSignals();

    bool setSpectrumValue(const TimeRange& tw, const AbstractParameters * param,
                          const FourierPlan& plan, const TaperDelegate& taper);

    inline Complex spectrumValue(int component, int iFreq) const;
    const Complex& spectrumValue(int component) const {return _spectrumValue[component];}
  protected:
    Point2D _relativePos;
    Complex _spectrumValue[3];
  };

  inline Complex ArrayStationSignals::spectrumValue(int component, int iFreq) const
  {
    return processed(component)->complex(processedSamples(component), iFreq);
  }

} // namespace ArrayCore

#endif // ARRAYSTATIONSIGNALS_H
