/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-12-09
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ActiveFKWorker.h"
#include "ActiveFKTaskManager.h"
#include "ArrayTask.h"
#include "ActiveFKParameters.h"

namespace ArrayCore {

  /*!
    \class ActiveFKWorker ActiveFKWorker.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ActiveFKWorker::ActiveFKWorker(const ArraySelection * array,
                                 const ActiveFKParameters * param,
                                 const SeismicEvent * source,
                                 IrregularGrid2D * grid)
    : FKWorker(array, param)
  {
    TRACE;
    crossSpectrum()->setActiveSource(source);
    _grid=grid;
  }

  /*!
    Description of destructor still missing
  */
  ActiveFKWorker::~ActiveFKWorker()
  {
    TRACE;
  }

  void ActiveFKWorker::process(const QVector<int>& blocks)
  {
    AbstractFKFunction * function=FKWorker::function();
    if(function && crossSpectrum()->calculate(blocks, function)) {
      double omega=crossSpectrum()->timeWindows()->frequency().omega();
      int frequencyIndex=crossSpectrum()->timeWindows()->frequencyIndex();
      for(int iSlow=0; iSlow<_grid->ny(); iSlow++) {
        _grid->setValue(frequencyIndex, iSlow, function->value(omega*_grid->y(iSlow)));
      }
      // Normalize FK spectrum frequency by frequency and following spectrum energy
      const ActiveFKParameters * param=static_cast<const ActiveFKParameters *>(crossSpectrum()->parameters());
      switch(param->beamPowerNormalization()) {
      case ActiveFKParameters::Raw:
        break;
      case ActiveFKParameters::Spectrum:
        _grid->multiplyValues(YAxis, frequencyIndex, 1.0/crossSpectrum()->matrix().trace(0.0).re());
        break;
      case ActiveFKParameters::Maximum: {
          Curve<Point2D> c=_grid->crossSection(YAxis, frequencyIndex);
          int im=c.maximumY();
          _grid->multiplyValues(YAxis, frequencyIndex, 1.0/c.y(im));
        }
        break;
      }
    }
  }

} // namespace ArrayCore

