/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-09-04
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTARRAYTOOL_H
#define ABSTRACTARRAYTOOL_H

#include <GeopsyCore.h>

#include "ArrayStations.h"
#include "ArrayParameters.h"
#include "ArrayCoreDLLExport.h"
#include "ArrayTaskManager.h"

namespace ArrayCore {

  class AbstractArrayResults;

  class ARRAYCORE_EXPORT AbstractArrayTool: public AbstractTool
  {
    Q_OBJECT
  public:
    AbstractArrayTool();
    virtual ~AbstractArrayTool();

    virtual bool setSubPool(SubSignalPool * subPool);

    const ArraySelection * array() const {return &_arraySelection;}

    SparseTimeRange timeRange() const;

    bool setParameters(const AbstractParameters& param);
    inline const ArrayParameters * parameters() const;
    inline ArrayParameters * parameters();

    double minimumFrequency(int nWindows, double periodCount) const;
    double maximumFrequency() const;
  public slots:
    void start();
  protected:
    bool setLoop();

    void setResults(AbstractArrayResults * r) {_results=r;}
    AbstractArrayResults * results() const {return _results;}

    virtual QString toolName()=0;
    StationSignals * belongsTo(Signal * sig);
  private:
    ArrayStations _array;
    ArraySelection _arraySelection;
    AbstractArrayResults * _results;
  };

  inline const ArrayParameters * AbstractArrayTool::parameters() const
  {
    return static_cast<const ArrayParameters *>(AbstractTool::parameters());
  }

  inline ArrayParameters * AbstractArrayTool::parameters()
  {
    return static_cast<ArrayParameters *>(AbstractTool::parameters());
  }

} // namespace ArrayCore

#endif // ABSTRACTARRAYTOOL_H
