/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-13
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REALTIMESTATIONSIGNALS_H
#define REALTIMESTATIONSIGNALS_H

#include <GeopsyCore.h>

class RealTimeStationSignals : public StationProcessSignals
{
public:
  RealTimeStationSignals(const StationSignals * originalSignals);
  ~RealTimeStationSignals();

  virtual bool setProcessed(const TimeRange& tw, const AbstractParameters * param);
  inline Complex getSignalSpectrum(int component, int iFreq);
};

inline Complex RealTimeStationSignals::getSignalSpectrum(int component, int iFreq)
{
  TRACE;
  return Complex(processed(component)->complex(processedSamples(component), iFreq) );
}

#endif // REALTIMESTATIONSIGNALS_H
