/***************************************************************************
**
**  This file is part of max2curve.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-05-29
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QTextStream>

#include <QGpCoreTools.h>
#include "SPACMaxEntry.h"

/*!
  \class SPACMaxEntry SPACMaxEntry.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

bool SPACMaxEntry::readLine(QTextStream& s)
{
  TRACE;
  QString line;
  do {
    line=s.readLine();
  } while(!line.isEmpty() && line[0]=='#');
  if(!line.isEmpty()) {
    const QChar * ptr=0;
    StringSection field,fields(line);
    field=fields.nextField(ptr);
    _time=field.toDouble();
    field=fields.nextField(ptr);
    _x=field.toDouble();
    field=fields.nextField(ptr);
    _component=field.toInt();
    field=fields.nextField(ptr);
    _ring=field.toInt();
    field=fields.nextField(ptr);
    _autocorr=field.toDouble();
    field=fields.nextField(ptr);
    if(field.isValid())
      _selected=field.toInt()>0 ? true : false;
    else
      _selected=true; // compatibility with format out of Geopsy and Cap
    return true;
  } else {
    return false;
  }
}

void SPACMaxEntry::writeLine(QTextStream& s) const
{
  TRACE;
  static const QString fmt("%1 %2 %3 %4 %5 %6");
  s << fmt.arg(_time).arg(_x).arg(_component).arg(_ring).arg(_autocorr).arg(_selected) << endl;
}

bool SPACMaxEntry::isHeaderLine(QString f)
{
  TRACE;
  return f.contains("secondsfromstart|cfreq|icomp|iring|autocorr");
}

QByteArray SPACMaxEntry::fields()
{
  TRACE;
  return "seconds from start | cfreq | icomp | iring | autocorr";
}

void SPACMaxEntry::writeHeader(QTextStream& s) const
{
  TRACE;
  s << "# File generated by max2curve, SPAC post-processing\n";
  s << QString( "# %1 | selected").arg(fields().data()) << endl;
}
