/***************************************************************************
**
**  This file is part of max2curve.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-10-27
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <SciFigs.h>

#include "FreqVelocityFilter.h"

/*
 *  Constructs a FreqVelocityFilter as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  true to construct a modal dialog.
 */
FreqVelocityFilter::FreqVelocityFilter(QWidget *parent, Qt::WindowFlags f)
    : Dialog(parent, f)
{
  TRACE;
  setupUi(this);
  connect(thresholdFilter, SIGNAL(toggled(bool)), this, SLOT(enableWidgets()));
  connect(waveNumberFilter, SIGNAL(toggled(bool)), this, SLOT(enableWidgets()));
  connect(curveFilter, SIGNAL(toggled(bool)), this, SLOT(enableWidgets()));
}

void FreqVelocityFilter::setCurveList(const QList<CurveProperties *>& list)
{
  TRACE;
  for(QList<CurveProperties *>::const_iterator it=list.begin(); it!=list.end(); it++) {
    curveName->addItem((*it)->proxy()->name());
  }
  if(curveName->count()==0) {
    curveFilter->setEnabled(false);
    curveFilter->setChecked(false);
  }
}

void FreqVelocityFilter::enableWidgets()
{
  TRACE;
  bool b;
  b=waveNumberFilter->isChecked() & waveNumberFilter->isEnabled();
  kmin->setEnabled(b);
  kmax->setEnabled(b);
  b=thresholdFilter->isChecked() & thresholdFilter->isEnabled();
  thresholdValue->setEnabled(b);
  b=curveFilter->isChecked() & curveFilter->isEnabled();
  curveName->setEnabled(b);
  curveSigma->setEnabled(b);
}
