/***************************************************************************
**
**  This file is part of gpspac.
**
**  gpspac is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpspac is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-09-03
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>
#include "SpacReader.h"
#include "gpspacVersion.h"
#include "gpspacInstallPath.h"

PACKAGE_INFO("gpspac", GPSPAC)

ApplicationHelp * help();

int main(int argc, char ** argv)
{
  CoreApplication a(argc, argv, help);

  SpacReader reader;
  if(reader.setOptions(argc, argv) && reader.read(argc, argv) ) {
    return 0;
  } else {
    return 2;
  }
}

ApplicationHelp * help()
{
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS] [FILE]" );
  h->setComments( "Compute autocorrelation curve for layered models given through stdin or FILE.\n\n"
                 "Format for layered models:\n"
                 + Seismic1DModel::formatHelp() +
                 "\n\n"
                 "Quality factors are not mandatory. If not specified, pure elastic computation is performed. Any number of models "
                 "can be given as input.");
  h->addGroup("Gpspac","gpspac");
  h->addOption("-n <count>","Number of samples (default=100)");
  h->addOption("-M <n modes>","Number of modes (default=1)");
  h->addOption("-one-mode","Instead of outputting all modes (see options '-M'), output only the highest one.");
  h->addOption("-vertical","Computes vertical autocorrelation curves (default).");
  h->addOption("-radial","Computes radial autocorrelation curves.");
  h->addOption("-transverse","Computes transverse autocorrelation curves.");
  h->addOption("-alpha <value>","Relative Rayleigh energy on horizontal components (default=0.5)");
  h->addOption("-s <sampling>","Defines the sampling type:\n"
                              "  period     regular sampling in period\n"
                              "  frequency  regular sampling in frequency\n"
                              "  log        regular sampling in log(frequency) (default)");
  h->addOption("-min <min>","Minimum of range for autocorrelation curve (default=0.2)");
  h->addOption("-max <max>","Maximum of range for autocorrelation curve (default=20)");
  h->addOption("-r <FILE>","Load rings from a 2-column file (min and max radii)");
  h->addOption("-rmin <min>","Add a ring with minimum radius in meters");
  h->addOption("-rmax <max>","Set maximum of last ring");
  h->addExample("gpspac -rmin 10 -rmin 20 -rmin 40 -rmin 80 < test.model", "Calculate fundamental autocorrelation curve from 0.2 Hz to 20 Hz for model 'test.model' and for rings at 10 m, 20 m, 40 m and 80 m.");
  h->addExample("gppac -rmin 10 -rmin 20 -rmin 40 -rmin 80 < test.model | figue -c -cpp 1", "Calculate the same autocorrelation curves and plot them.");
  h->addExample("gpspac -rmin 10 -rmin 20 -rmin 40 -rmin 80 < test.model | figue -c -cpp 1 -m spac.mkup", "Show the same autocorrelation curves on a log plots. 'spac.mkup' is a tar.gz file containing an xml description of the graphic format, it can be generated from figue's interface.");
  return h;
}
