/***************************************************************************
**
**  This file is part of gpsignal.
**
**  gpsignal is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpsignal is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-05-21
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "SignalReader.h"
#include "gpsignalVersion.h"
#include "gpsignalInstallPath.h"

PACKAGE_INFO("gpsignal", GPSIGNAL)

double misfit(double ampPhi[]);
ApplicationHelp * help();

int main(int argc, char ** argv)
{
  CoreApplication a(argc, argv, help);
  a.debugUserInterrupts(false);

  SignalReader reader;
  if( !reader.setOptions(argc, argv) || !reader.read(argc, argv) ) {
    return 2;
  }
  reader.exec();
  return 0;
}

ApplicationHelp * help()
{
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS]" );
  h->setComments("Generate a signal defined by a sum of cosine signals. Each cosine is "
                 "defined by its amplitude, frequency, phase (in degrees), azimuth, velocity given through stdin.\n"
                 "If all cosines have the same frequency, the resulting cosine is computed." );
  h->addGroup("Gpsignal options", "gpsignal");
  h->addOption("-f <VAL>","Sampling frequency (default=100 Hz)");
  h->addOption("-t <VAL>","Time length in seconds (default=600 s.)");
  h->addOption("-x <VAL>","X coordinate of station, see option -v (default=0).");
  h->addOption("-y <VAL>","Y coordinate of station, see option -v (default=0).");
  h->addOption("-grid <N S>","Generate signals for a grid of size S with N bins.");
  h->addOption("-dc <FILE>", "Load a dispersion curve defined by frequency and slowness, option '-v' is ignored in that case.");
  h->addOption("-square", "Generate square binary signals instead of cosine.");
  h->addExample("gpsignal << END > signal.txt\n3 1 0\n0.5 10 180\nEND",
                "Generate a signal with two frequencies 1 (amplitude 3, phase 0) and 10 Hz (amplitude 0.5, phase 180), ");
  return h;
}
