/***************************************************************************
**
**  This file is part of gpmt.
**
**  gpmt is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpmt is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-27
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MAGNETOTELLURICREADER_H
#define MAGNETOTELLURICREADER_H

#include <QGpCoreWave.h>

class MagnetoTelluricReader : public ArgumentStdinReader
{
  TRANSLATIONS("MagnetoTelluricReader");
public:
  MagnetoTelluricReader();

  bool setOptions(int& argc, char ** argv);
protected:
  virtual bool parse(QTextStream& s);
private:
  SamplingOption _samplingType;
  int _nSamples;
  double _minRange;
  double _maxRange;

  MagnetoTelluricPointOptions::OutputMode _outputMode;
};

#endif // MAGNETOTELLURICREADER_H
