/***************************************************************************
**
**  This file is part of gpmodel2param.
**
**  gpmodel2param is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpmodel2param is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-06-27
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>
#include "Model2ParamReader.h"
#include "gpmodel2paramVersion.h"
#include "gpmodel2paramInstallPath.h"

PACKAGE_INFO("gpmodel2param", GPMODEL2PARAM);

ApplicationHelp * help();

int main(int argc, char ** argv)
{
  CoreApplication a(argc, argv, help);

  Model2ParamReader reader;
  if(reader.setOptions(argc, argv) && reader.read(argc, argv) ) {
    return 0;
  } else {
    return 2;
  }
}

ApplicationHelp * help()
{
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS] [FILE]" );
  h->setComments( "Output a parametrized ground model from a layered model given through stdin or FILE\n\n"
                 "Format for layered models:\n"
                 + Seismic1DModel::formatHelp() +
                 "\n\n"
                 "Quality factors are not mandatory. Any number of models can be given as input.");
  h->addGroup("Gpmodel2param","gpmodel2param");
  h->addOption( "-o","Ouput parameter file (default=out.param).");
  h->addOption( "-vs-relative-range <R>","Sets Vs range equal to [Vs*(1-R), Vs*(1+R)] (default R=0, i.e. fixed).");
  return h;
}
