/***************************************************************************
**
**  This file is part of gpmaplayer.
**
**  gpmaplayer is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpmaplayer is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-03-27
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef COLUMNIMAGEMERGER_H
#define COLUMNIMAGEMERGER_H

#include <QtGui>
#include <QGpCoreMath.h>
#include <GeopsyCore.h>

#include "ImageMerger.h"

class ColumnImageMerger : public ImageMerger
{
public:
  ColumnImageMerger(double lon, double minLat, double maxLat, double step);
  ~ColumnImageMerger();

  const Point2D& center(int index) const {return _centers.at(index);}
  const Point2D& center() const {return _centers.at(_currentIndex);}
  bool atEnd() const {return _currentIndex>=_centers.count();}
  int count() const {return _centers.count();}
  void setImage(const QImage &im, int minShift, int maxShift);
  const QImage& image() const {return _image;}

  static int getPixelShift(const QImage& im1, const QImage& im2, int minShift, int maxShift, bool& ok);
private:
  static DoubleSignal * imageVector(const QImage& im, int maxHeight=0);

  QVector<Point2D> _centers;
  int _currentIndex;
  QImage _image;
};

#endif // COLUMNIMAGEMERGER_H
