/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-15
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SEISMIC1DTHREAD_H
#define SEISMIC1DTHREAD_H

#include "CurvesThread.h"

class Seismic1DThread : public CurvesThread
{
public:
  Seismic1DThread(QObject * parent=nullptr);
  Seismic1DThread(const Seismic1DThread& o);
  ~Seismic1DThread();

  virtual bool setParameters(int& argc, char ** argv);
  virtual void initModelGraphs(GraphicSheet * sheet);
  virtual void initModelGraphs(const ResultsThread& o);

  virtual void addModel(GeophysicalModel * m);
  virtual void setModel(GeophysicalModel * m);
  virtual void clear();
  virtual void modelDeepUpdate();
  virtual void setModelLimits();

  virtual LegendWidget * legend() const {return _leg;}
private:
  virtual GeophysicalModel * createModel() const {return new Seismic1DModel;}

  LineLayer * _vp;
  LineLayer * _vs;
  LegendWidget * _leg;
};

#endif // SEISMIC1DTHREAD_H
