/***************************************************************************
**
**  This file is part of geopsynr.
**
**  geopsynr is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsynr is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-12
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef T0CORRELATION_H
#define T0CORRELATION_H

#include <GeopsyCore.h>
#include <QGpCoreTools.h>

class ShotRecord;

class T0Correlation : public AbstractFunction
{
public:
  T0Correlation(ShotRecord * refShot, ShotRecord * shot);

  void setTimeLimits(const TimeRangeParameters& timeLimits) {_timeLimits=timeLimits;}
  void setReceiverRange(int minRecIndex, int maxRecIndex);

  virtual double value(const Point& p, int) const;
  virtual double value(const Point& p) const;
protected:
  double correlationInterpolate(double t0);
private:
  ShotRecord * _refShot;
  ShotRecord * _shot;
  int _minRecIndex, _maxRecIndex;
  mutable TimeRangeParameters _timeLimits;
};

#endif // T0CORRELATION_H
