/***************************************************************************
**
**  This file is part of geopsyarray.
**
**  geopsyarray is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyarray is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-09-04
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FKToolWidget_H
#define FKToolWidget_H

#include <ArrayCore.h>
#include <GeopsyGui.h>

#include "ui_FKToolWidget.h"

class FKToolWidget : public AbstractToolWidget, protected Ui::FKToolWidget
{
  Q_OBJECT
public:
  FKToolWidget(QWidget * parent);
  ~FKToolWidget();

  virtual bool setSubPool(SubSignalPool * subPool);

  FKTool * tool() {return static_cast<FKTool *>(_tool);}
  const FKTool * tool() const {return static_cast<const FKTool *>(_tool);}
public slots:
  virtual void start();
  void stop();
  virtual void test();
protected slots:
  void parametersChanged();
  void finish();

  void gridStepChanged();
  void gridSizeChanged();
  void setWaveNumberGrid();
private slots:
  void on_freqScroll_valueChanged(int index);
  void on_testFrequency_valueChanged(const QString&);
  void numFreqChanged();
  void on_outputFileNameBrowse_clicked();
  void on_outputFileNameEdit_textChanged(QString);

  void on_processTypeEdit_currentIndexChanged(int index);
  void on_inversionMethodEdit_currentIndexChanged(int index);
protected:
  QString outputFileName();

  void setTimeWindowLayer(TimeWindowList * winList);
  void setRunning(bool r, const QString& message=QString());
  virtual void restoreFields();
  virtual void updateAllFields();

  void getParameters(FKParameters& param) const;
  virtual void setParameters(const AbstractParameters * param);
  virtual AbstractParameters * parameters(AbstractParameters * param=nullptr) const;
  bool checkParameters(FKParameters * param) const;

  FKParameters::ProcessType processType(int t) const;
  int processType(FKParameters::ProcessType t) const;

  static FKParameters::InversionMethod inversionMethod(int m);
  static int inversionMethod(FKParameters::InversionMethod m);

private:
  bool _outputFileChecked;
  bool _exportAllFKGrids;

  bool _gridSizeTouched, _gridStepTouched;
  QTimer _kmaxTimer;
  double _currentTestFrequency;

  MessageContext _context;
};

#endif
