/***************************************************************************
**
**  This file is part of campbelltob3.
**
**  campbelltob3 is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  campbelltob3 is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-12-18
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <GeopsyGui.h>

#include "CampbellLoader.h"
#include "Tob3Scanner.h"

/*!
  \class CampbellLoader CampbellLoader.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
CampbellLoader::CampbellLoader(QWidget * parent)
  : Dialog(parent)
{
  TRACE;
  setupUi(this);

  SparseTimeRangeModel *model=new SparseTimeRangeModel(this);
  rangeTable->setModel(model);
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
  rangeTable->horizontalHeader()->setSectionResizeMode(0, QHeaderView::Stretch);
#else
  rangeTable->horizontalHeader()->setResizeMode(0, QHeaderView::Stretch);
#endif

  _scanner=new Tob3Scanner(this);
  model->setRange(_scanner->range(), _scanner->rangeMutex());

  connect(inputFileName, SIGNAL(editTextChanged(const QString&)), this, SLOT(scan()));
  connect(_scanner, SIGNAL(beginAddRange(int)), model, SLOT(beginAddRange(int)));
  connect(_scanner, SIGNAL(endAddRange()), model, SLOT(endAddRange()));
  connect(_scanner, SIGNAL(beginClearRange()), model, SLOT(beginClearRange()));
  connect(_scanner, SIGNAL(endClearRange()), model, SLOT(endClearRange()));
  connect(_scanner, SIGNAL(headerParsed()), this, SLOT(startTimeReady()));
  connect(rangeTable, SIGNAL(doubleClicked(QModelIndex)), this, SLOT(setTimeLimits(QModelIndex)));

  inputFileName->addItems(Settings::getHistory("CampbellInputFile"));
}

/*!
  Description of destructor still missing
*/
CampbellLoader::~CampbellLoader()
{
  TRACE;
}

void CampbellLoader::scan()
{
  TRACE;
  if(!inputFileName->currentText().isEmpty()) {
    _scanner->setFileName(inputFileName->currentText());
  }
}

void CampbellLoader::on_inputBrowse_clicked()
{
  TRACE;
  QString s=Message::getOpenFileName(tr("Campbell file"), tr("Campbell TOB3 (*.dat)"));
  if(!s.isEmpty()) {
    inputFileName->setEditText(s);
  }
}

void CampbellLoader::startTimeReady()
{
  TRACE;
  loadBut->setEnabled(true);
  rangeTable->resizeColumnsToContents();
  // File has been validated, add to history
  Settings::setHistory("CampbellInputFile", inputFileName->currentText());
}

void CampbellLoader::setTimeLimits(QModelIndex index)
{
  TRACE;
  const TimeRange& r=_scanner->range()->ranges().at(index.row());
  if(index.column()==0) {
    fromTime->setDateTime(r.start().dateTime());
  } else {
    toTime->setDateTime(r.end().shifted(0.9999).dateTime());
  }
}

void CampbellLoader::on_loadBut_clicked()
{
  TRACE;
  bool ok;
  double minSigLen=Number::durationToSeconds(minSignalLength->text(), ok);
  double maxSigLen=Number::durationToSeconds(maxSignalLength->text(), ok);
  if(ok) {
    SubSignalPool pool=_scanner->load(GeopsyGuiEngine::instance()->database(this),
                                      TimeRange(fromTime->dateTime(), toTime->dateTime()),
                                      minSigLen, maxSigLen);
    // Set components or other user editing
    SignalHeaderScript script(&pool);
    script.run(headerScript->toPlainText());
    close();
  }
}
