/***************************************************************************
**
**  This file is part of WaranCore.
**
**  WaranCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  WaranCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-26
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GPSFIX_H
#define GPSFIX_H

#include "WaranCoreDLLExport.h"

namespace WaranCore {

class WARANCORE_EXPORT GpsFix
{
public:
  inline GpsFix();

  enum State {NoFix=0, Fix2D, Fix3D, TimeFix};

  void setState(State s) {_state=s;}
  State state() const {return _state;}

  void reset();

  int& longitude() {return _longitude;}
  const int& longitude() const {return _longitude;}
  int& latitude() {return _latitude;}
  const int& latitude() const {return _latitude;}
  int& altitude() {return _altitude;}
  const int& altitude() const {return _altitude;}
  int& horizontalAccuracy() {return _horizontalAccuracy;}
  const int& horizontalAccuracy() const {return _horizontalAccuracy;}
  unsigned short& horizontalDop() {return _horizontalDop;}
  const unsigned short& horizontalDop() const {return _horizontalDop;}
  unsigned short& northingDop() {return _northingDop;}
  const unsigned short& northingDop() const {return _northingDop;}
  unsigned short& eastingDop() {return _eastingDop;}
  const unsigned short& eastingDop() const {return _eastingDop;}
  unsigned char& sateliteCount() {return _sateliteCount;}
  const unsigned char& sateliteCount() const {return _sateliteCount;}
private:
  State _state;
  int _longitude;
  int _latitude;
  int _altitude;
  int _horizontalAccuracy;
  unsigned short _horizontalDop;
  unsigned short _northingDop;
  unsigned short _eastingDop;
  unsigned char _sateliteCount;
};

inline GpsFix::GpsFix()
{
  _state=NoFix;
}

} // namespace WaranCore

#endif // GPSFIX_H
