/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2002-05-07
**  Copyright: 2002-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef XYCOLORPLOT_H
#define XYCOLORPLOT_H

#include "XYPlot.h"

namespace SciFigs {

class SCIFIGS_EXPORT XYColorPlot : public XYPlot
{
  Q_OBJECT
public:
  XYColorPlot(AxisWindow * parent=nullptr);
  ~XYColorPlot();

  virtual const QString& xml_tagName() const {return xmlXYColorPlotTag;}
  static const QString xmlXYColorPlotTag;

  void setPointColors(QVector<QColor> * c);
protected:
  QVector<QColor> * _pointColor;

  virtual void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
  virtual void xml_writeBinaryData(XML_WRITEBINARYDATA_ARGS) const;
  virtual bool xml_setBinaryData(XML_SETBINARYDATA_ARGS);
};

} // namespace SciFigs

#endif // XYCOLORPLOT_H
