/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-07-30
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TEXTEDIT_H
#define TEXTEDIT_H

#include "GraphicObject.h"
#include "Font.h"
#include "SciFigsGlobal.h"

namespace SciFigs {

class TextEditProperties;

class SCIFIGS_EXPORT TextEdit :  public GraphicObject
{
  Q_OBJECT
  Q_PROPERTY(bool textAsData READ isTextAsData WRITE setTextAsData SCRIPTABLE true)
  Q_PROPERTY(QString text READ text WRITE setText SCRIPTABLE true)
  Q_PROPERTY(QString font READ fontString WRITE setFont SCRIPTABLE true)
  Q_PROPERTY(bool adjustBox READ adjustBox WRITE setAdjustBox SCRIPTABLE true)
public:
  TextEdit(QWidget * parent=nullptr);
  ~TextEdit();

  virtual const QString& xml_tagName() const {return xmlTextEditTag;}
  static const QString xmlTextEditTag;

  QString text() const {return _text;}
  void setText(QString t);

  bool adjustBox() const {return _adjustBox;}
  void setAdjustBox(bool t);

  bool isTextAsData() const {return _textAsData;}
  void setTextAsData(bool b) {_textAsData=b;}

  QString fontString() const {return _font.toString();}
  void setFont(const QFont& f);
  void setFont(const QString& f);

  void adjustSize();

  virtual void addProperties(PropertyProxy * pp);
  virtual void removeProperties(PropertyProxy * pp);
  virtual void properties(PropertyWidget * w) const;
  virtual void setProperty(uint wid, int pid, QVariant val);
public slots:
  virtual void showProperties() {GraphicObject::showProperties(_category);}
protected:
  void adjustSize(int& width, int& height);
  virtual void paint(QPainter& p, double dotpercm,int w, int h, bool mask);
  virtual void setPrintSize(double dotpercm);

  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);

  QString _text;
  Font _font;
  bool _adjustBox;
  bool _textAsData;

  static uint _category, _tabFormat;
};

} // namespace SciFigs

#endif // TEXTEDIT_H
