/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-01-26
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef NAMELINEDELEGATE_H
#define NAMELINEDELEGATE_H

#include <QItemDelegate>

#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT NameLineDelegate : public QItemDelegate
{
  Q_OBJECT;
public:
  NameLineDelegate(QObject *parent=0) : QItemDelegate(parent) {}

  QWidget * createEditor(QWidget * parent, const QStyleOptionViewItem & option, const QModelIndex &index) const;
  void setEditorData(QWidget *editor, const QModelIndex &index) const;
  void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const;
private slots:
  void commitWidgetData();
signals:
  void dataChanged() const;
};

} // namespace SciFigs

#endif // NAMELINEDELEGATE_H
