/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-09-26
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ListInterpole.h"
#include "Legend.h"

namespace SciFigs {

/*!
  \class ListInterpole ListInterpole.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Populate with colors from a color palette
*/
void ListInterpole::setColors(const ColorPalette& pal)
{
  TRACE;
  setWindowTitle(tr("Interpole colors"));

  int n=pal.count();
  QPixmap pm(20,20);
  QPainter p;
  QColor col;
  for(int i=0 ; i<n; i++) {
    guiColor(pal.color(i), col);
    p.begin(&pm);
    p.fillRect(0, 0, 20, 20, col);
    p.end();
    QString str=QString::number(i+1);
    fromList->addItem(pm,str);
    fromList->setItemData(i, col, Qt::BackgroundRole);
    toList->addItem(pm,str);
    toList->setItemData(i, col, Qt::BackgroundRole);
  }
  on_lastEntry_clicked(); // Force the last value by default
}

/*!
  Populate with values from a color palette
*/
void ListInterpole::setValues(const ColorMap& pal)
{
  TRACE;
  setWindowTitle(tr("Interpole values"));

  int n=pal.count()-1;
  static const QString str0("%1: %2");
  for(int i=0 ; i<n; i++) {
    QString str=str0.arg(i+1).arg(pal.upperValue(i));
    fromList->addItem(str);
    toList->addItem(str);
  }
  on_lastEntry_clicked(); // Force the last value by default
}

int ListInterpole::fromIndex() const
{
  TRACE;
  return fromList->currentIndex();
}

int ListInterpole::toIndex() const
{
  TRACE;
  return toList->currentIndex();
}

void ListInterpole::on_firstEntry_clicked()
{
  TRACE;
  fromList->setCurrentIndex(0);
}

void ListInterpole::on_lastEntry_clicked()
{
  TRACE;
  toList->setCurrentIndex(toList->count()-1);
}


} // namespace SciFigs
