/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-11-03
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LINEFACTORY_H
#define LINEFACTORY_H

#include <QGpCoreTools.h>

#include "SciFigsDLLExport.h"
#include "AbstractLine.h"

namespace SciFigs {

  #define REGISTER_LINE(_className_, _tagName_) \
    XMLREGISTER_HEAD(LineFactory, XMLClassCreator, _className_, _tagName_) \
    XMLREGISTER_TAIL(_className_)

  #define SYNONYM_LINE(_synName_, _tagName_) \
    XMLSYNONYM(LineFactory, _synName_, _tagName_)

  class SCIFIGS_EXPORT LineFactory : public XMLClassFactory
  {
  public:
    inline AbstractLine * create(int id) const;
    inline AbstractLine * create(const QString& tag) const;

    static void init();
    static LineFactory * instance() {init(); return _self;}
  private:
    static LineFactory * _self;
  };

  inline AbstractLine * LineFactory::create(int id) const
  {
    return static_cast<AbstractLine *>(XMLClassFactory::create(id));
  }

  inline AbstractLine * LineFactory::create(const QString& tag) const
  {
    return static_cast<AbstractLine *>(XMLClassFactory::create(tag));
  }

} // namespace SciFigs

#endif // LINEFACTORY_H
