/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-07-04
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "GridProperties.h"
#include "GridPlot.h"
#include "GraphContent.h"

namespace SciFigs {

GridProperties::GridProperties(QWidget * parent)
    : PropertyWidget(parent)
{
  TRACE;
  setupUi(this);

  // Create properties
  addProperty(ShowGrid, showGrid);
  addProperty(Smooth, smooth);
  addProperty(FillValue, valueEdit, valueLabel);
  addProperty(FillValueInversed, valueInversedEdit, valueInversedLabel);
  addProperty(FillType, fillTypeEdit);
}

Rect::Area GridProperties::item2area(int index)
{
  switch (index) {
  case 1:
    return Rect::AboveAscDiag;
  case 2:
    return Rect::BelowAscDiag;
  case 3:
    return Rect::AboveDescDiag;
  case 4:
    return Rect::BelowDescDiag;
  default:
    return Rect::AllRect;
  }
}

int GridProperties::area2item(Rect::Area ft)
{
  switch (ft) {
  case Rect::AboveAscDiag:
    return 1;
  case Rect::BelowAscDiag:
    return 2;
  case Rect::AboveDescDiag:
    return 3;
  case Rect::BelowDescDiag:
    return 4;
  default:
    return 0;
  }
}

} // namespace SciFigs
