/***************************************************************************
**
**  This file is part of SciFigs.
**
**  SciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  SciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-11
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "GraphicObjectList.h"
#include "GraphicObject.h"
#include "SciFigsGlobal.h"

namespace SciFigs {

  /*!
    \class GraphicObjectList GraphicObjectList.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  GraphicObject * GraphicObjectList::findObject(QString tagName, QString objectName) const
  {
    TRACE;
    int n=count();
    GraphicObject * w;
    // First look for a perfect match for object name
    for(int i=0; i<n; i++) {
      w=at(i);
      if(w->xml_tagName()==tagName &&
         (objectName.isNull() || objectName==w->objectName())) {
        return w;
      }
    }
    // Second look for a perfect match for object name with case insensitivity
    objectName=objectName.toLower();
    for(int i=0; i<n; i++) {
      w=at(i);
      if(w->xml_tagName()==tagName &&
         (objectName.isNull() || objectName==w->objectName().toLower())) {
        return w;
      }
    }
    // Third look for an object name that starts with objectName
    for(int i=0; i<n; i++) {
      w=at(i);
      if(w->xml_tagName()==tagName &&
         w->objectName().toLower().startsWith(objectName)) {
        return w;
      }
    }
    // Fourth look for an object name that contains the first 5 characters of objectName
    objectName=objectName.left(5).toLower();
    for(int i=0; i<n; i++) {
      w=at(i);
      if(w->xml_tagName()==tagName &&
         w->objectName().toLower().contains(objectName)) {
        return w;
      }
    }
    return nullptr;
  }


  QString GraphicObjectList::uniqueName(GraphicObject * namedW, QString newName) const
  {
    TRACE;
    QList<GraphicObject *>::const_iterator it;
    for(it=begin(); it!=end(); ++it) {
      if(namedW!=*it && newName==(*it)->objectName()) {
        int i=newName.lastIndexOf('_');
        int n;
        if(i>-1) {
          bool ok;
          n=newName.right(newName.length()-i-1).toInt(&ok)+1;
          if(ok) {
            newName=newName.left(i);
          } else {
            n=0;
          }
        } else {
          n=0;
        }
        newName=(newName+"_")+QString::number(n);
        it=begin();
      }
    }
    return newName;
  }

  void GraphicObjectList::setPos() const
  {
    TRACE;
    for(int i=count()-1; i>=0; i--) {
      at(i)->setPos();
    }
  }

  void GraphicObjectList::setSize() const
  {
    TRACE;
    for(int i=count()-1; i>=0; i--) {
      at(i)->setSize();
    }
  }

  void GraphicObjectList::show() const
  {
    TRACE;
    for(int i=count()-1; i>=0; i--) {
      at(i)->show();
    }
  }

  void GraphicObjectList::startDragging() const
  {
    TRACE;
    for(int i=count()-1; i>=0; i--) {
      at(i)->startDragging();
    }
  }

  Rect GraphicObjectList::boundingRect() const
  {
    TRACE;
    int n=count();
    if(n==0) {
      return Rect();
    }
    GraphicObject * obj=first();
    Rect r(obj->printLeft(), obj->printTop(),
           obj->printRight(), obj->printBottom());
    for(int i=1; i<n; i++) {
      obj=at(i);
      r.add(obj->printLeft(), obj->printTop());
      r.add(obj->printRight(), obj->printBottom());
    }
    return r;
  }


} // namespace SciFigs

