/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-02-22
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ModeDelegate.h"

namespace QGpGuiWave {

  /*!
    \class ModeDelegate ModeDelegate.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    \fn ModeDelegate::ModeDelegate()
    Description of constructor still missing
  */

  ModeDelegate::ModeDelegate(QObject *parent)
    : QItemDelegate(parent)
  {
    TRACE;
    _type=Mode::Dispersion;
  }

  QWidget * ModeDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem &, const QModelIndex &index) const
  {
    TRACE;
    switch(_type) {
    case Mode::Dispersion:
      break;
    case Mode::Autocorr:
      switch (index.column()) {
      case 0: {
          QComboBox * w=new QComboBox(parent);
          w->addItem(Mode::userPolarization(Mode::Vertical));
          w->addItem(Mode::userPolarization(Mode::Radial));
          w->addItem(Mode::userPolarization(Mode::Transverse));
          return w;
        }
      case 1: {
          QSpinBox * w=new QSpinBox(parent);
          return w;
        }
      default:
        return nullptr;
      }
    case Mode::Ellipticity:
      switch (index.column()) {
      case 0: {
          QComboBox * w=new QComboBox(parent);
          w->addItem(Mode::userValue(Mode::Signed));
          w->addItem(Mode::userValue(Mode::Absolute));
          return w;
        }
      case 1: {
          QSpinBox * w=new QSpinBox(parent);
          return w;
        }
      default:
        return nullptr;
      }
    }
    switch (index.column()) {
    case 0: {
        QComboBox * w=new QComboBox(parent);
        w->addItem(Mode::userSlowness(Mode::Phase));
        w->addItem(Mode::userSlowness(Mode::Group));
        return w;
      }
    case 1: {
        QComboBox * w=new QComboBox(parent);
        w->addItem(Mode::userPolarization(Mode::Rayleigh));
        w->addItem(Mode::userPolarization(Mode::Love));
        return w;
      }
    case 2: {
        QSpinBox * w=new QSpinBox(parent);
        return w;
      }
    default:
      return nullptr;
    }
  }

  int ModeDelegate::modeIndexColumn() const
  {
    TRACE;
    switch(_type) {
    case Mode::Dispersion:
      break;
    case Mode::Autocorr:
    case Mode::Ellipticity:
      return 1;
    }
    return 2;
  }

  void ModeDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
  {
    TRACE;
    if(index.column()==modeIndexColumn()) {
      QSpinBox * w=qobject_cast<QSpinBox *>(editor);
      if(!w) return;
      w->setValue(index.model()->data(index).toInt());
    } else {
      QComboBox * w=qobject_cast<QComboBox *>(editor);
      if( !w) return;
      int pos=w->findText(index.model()->data(index).toString(), Qt::MatchExactly);
      w->setCurrentIndex(pos);
    }
  }

  void ModeDelegate::setModelData(QWidget *editor, QAbstractItemModel *model,
                                  const QModelIndex &index) const
  {
    TRACE;
    if(index.column()==modeIndexColumn()) {
      QSpinBox * w=qobject_cast<QSpinBox *>(editor);
      if(!w) return;
      model->setData(index, w->value());
    } else {
      QComboBox * w=qobject_cast<QComboBox *>(editor);
      if(!w) return;
      model->setData(index, w->currentText());
    }
  }

} // namespace QGpGuiWave
