/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-09-16
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>

#include "SizeGrip.h"

namespace QGpGuiTools {

  /*!
    \class SizeGrip SizeGrip.h
    \brief Adds a size grip in the left/right bottom corner of a widget.
  */

  /*!
    Description of constructor still missing
  */
  SizeGrip::SizeGrip(QWidget * parent)
    : QObject(parent)
  {
    TRACE;
    parent->installEventFilter(this);
    _grip=0;
    setEnabled(true); // Enabled by default
  }

  /*!
    Description of destructor still missing
  */
  SizeGrip::~SizeGrip()
  {
    TRACE;
    delete _grip;
  }

  void SizeGrip::setEnabled(bool enabled)
  {
    TRACE;
    if(enabled) {
      if(!_grip) {
        _grip=new QSizeGrip(static_cast<QWidget *>(parent()));
        _grip->resize(_grip->sizeHint());
        resizeEvent();
      }
    } else {
      delete _grip;
      _grip=0;
    }
  }

  bool SizeGrip::eventFilter(QObject *, QEvent * e)
  {
    TRACE;
    if(e->type()==QEvent::Resize) {
      resizeEvent();
    }
    return false;
  }

  /*!
    Call this function in resizeEvent(QResizeEvent *) from parent widget.
  */
  void SizeGrip::resizeEvent()
  {
    TRACE;
    if(_grip) {
      if(QApplication::isRightToLeft()) {
        _grip->move(static_cast<QWidget *>(parent())->rect().bottomLeft()-_grip->rect().bottomLeft());
      } else {
        _grip->move(static_cast<QWidget *>(parent())->rect().bottomRight()-_grip->rect().bottomRight());
      }
      _grip->raise();
    }
  }

} // namespace QGpGuiTools
